﻿function b64EncodeUnicode(str) {
    // first we use encodeURIComponent to get percent-encoded UTF-8,
    // then we convert the percent encodings into raw bytes which
    // can be fed into btoa.
    return btoa(encodeURIComponent(str).replace(/%([0-9A-F]{2})/g,
        function toSolidBytes(match, p1) {
            return String.fromCharCode('0x' + p1);
        }));
}

var $arrFieldNames = Array();
$arrFieldNames.push("GivenName");
$arrFieldNames.push("FamilyName");
$arrFieldNames.push("EntityName");
$arrFieldNames.push("UBOBPNumber");
$arrFieldNames.push("BCEntity");
$arrFieldNames.push("EmailAddreess");
$arrFieldNames.push("EntityType");
$arrFieldNames.push("RegistrationNumber");
$arrFieldNames.push("ServiceRequestNumber");
$arrFieldNames.push("UBOType");
$arrFieldNames.push("Gender");
$arrFieldNames.push("PlaceOfRegistration");
$arrFieldNames.push("Passport");
$arrFieldNames.push("Nationality");
$arrFieldNames.push("PhoneNumber");
$arrFieldNames.push("Postcode");
$arrFieldNames.push("Emirates");
$arrFieldNames.push("City");
var $nRowIndex = 1;
$(document).ready(function () {
    //fnAddRow();
    if ($existingJSON != undefined && $existingJSON != '') {
        fnLoadJSON($existingJSON);
    }
});

function fnAddRow($boolValue, $fieldName, $fieldValue) {
    var $rowCount = $('#searchTable tr').length;
    if ($boolValue == undefined || $boolValue == '') {
        $boolValue = 'AND';
    }
    if ($fieldName == undefined || $fieldName == '') {
        $fieldName = '';
    }
    if ($fieldValue == undefined || $fieldValue == '') {
        $fieldValue = '';
    }

    // Boolean Operator
    
    var $boolean = "<select id='bool_" + $nRowIndex + "' class='form-control'><option selected value='" + $boolValue+"'>AND</option><option value='OR'>OR</option></select>";
    if ($rowCount == 1) {
        $boolean = "&nbsp;-&nbsp;"
    }
    // Field Selector
    var $fieldSelector = "<select id='fieldname_" + $nRowIndex + "' class='form-control'>";
    for (i = 0; i < $arrFieldNames.length; i++) {
        if ($fieldName == $arrFieldNames[i]) {
            $fieldSelector += "<option selected>" + $arrFieldNames[i] + "</option>";
        }
        else {
            $fieldSelector += "<option>" + $arrFieldNames[i] + "</option>";
        }
    }
    $fieldSelector += "</select>";
    // Search Data Text box
    var $searchTextBox = "<input id='searchData_" + $nRowIndex + "' value='" + $fieldValue + "' class='form-control' placeholder='Enter search data'/>";
    // Action Button
    var $actionButton = "<button id='button_" + $nRowIndex + "' class='btn btn-primary btn-sm' data-index='" + $nRowIndex + "' >Remove</button>";

    // Row creation
    var $row = "<tr id='row_" + $nRowIndex + "'>";
    $row += "<td>" + $boolean + "</td>";
    $row += "<td>" + $fieldSelector + "</td>"
    $row += "<td>" + $searchTextBox + "</td>"
    $row += "<td>" + $actionButton + "</td>"
    $row += "</tr>";

    $("#searchBody").append($row);
    $("#button_" + $nRowIndex).bind("click", fnHandleRemove);
    $nRowIndex += 1;
}

$("#addSearchField").click(function () {
    fnAddRow();
});

function fnHandleRemove(e) {
    e.preventDefault();
    $index = this.getAttribute("data-index");
    $('#row_' + $index).hide(250);
    $JSon = fnGenerateJSON($index);
    fnLoadJSON($JSon);
};

// This function generates the JSON for the search
function fnGenerateJSON($ignoreIndex) {
    
    $outJson = { "searchdata": [] };
    $bDone = false;
    $index = 1;
    $firstEntry = true;
    while ($bDone == false) {
        if ($('#row_' + $index).length != 0) {
            if ($('#row_' + $index).is(':visible') == true && $index != $ignoreIndex) {
                $booleanOperator = $('#bool_' + $index).val();
                if ($booleanOperator == undefined) {
                    $booleanOperator = "";
                }
                if ($firstEntry == true) {
                    $booleanOperator = "";
                    $firstEntry = false;
                }
                $fieldName = $('#fieldname_' + $index).val();
                $searchData = $('#searchData_' + $index).val();
                $outJson['searchdata'].push({ "bool": $booleanOperator, "field": $fieldName, "data": $searchData });
            }
        }
        else {
            $bDone = true;
        }
        $index += 1;
    }
    $Json = JSON.stringify($outJson);
    return $Json;
}

// this function loads the json into the UI
function fnLoadJSON($configuredJSON) {
    $("#searchBody").empty();
    $nRowIndex = 1;
    $objJSON = JSON.parse($configuredJSON);
    if ($objJSON["searchdata"] != undefined) {
        $entries = $objJSON["searchdata"];
        for (j = 0; j < $entries.length; j++) {
            $objEntry = $entries[j];
            fnAddRow($objEntry.bool, $objEntry.field, $objEntry.data);
        }
    }
}

$("#sessionParams").submit(function () {
    try {        
        $Json = fnGenerateJSON();
        $Base64Json = b64EncodeUnicode($Json);
        $("#FilterJSON").val($Base64Json);
    }
    catch (e) { console.log(e.message); }

});