﻿

var $selectedIdentity = "";
var $userRole = -1;

$(document).ready(function () {
    var selected = [];
    var $datatablesResponsive1 = $('#galaxkey_table1');
    if ($datatablesResponsive1 != undefined) {
        var $dtTable = $datatablesResponsive1.DataTable({
            responsive: true,
            order: [0, "desc"],
            dom: "<'row'<'col-sm-6 col-sm-push-6'i><'col-sm-6 col-md-pull-6'f>>" + "<'row'<'col-sm-12'tr>>" + "<'row'<'col-sm-6'l><'col-sm-6'p>>",
            language: {
                paginate: {
                    previous: '&laquo;',
                    next: '&raquo;'
                },
                search: "_INPUT_",
                searchPlaceholder: "Search…"
            },
            "columnDefs": [
                {
                    "targets": [0],
                    "visible": false,
                }
            ]

        });
        fnLoadRecords("50");
    }

    // called when user click on "Change" button.
    $(".btnUpdateCount").click(function (e) {
        var $iCount = 0;
        $recordCount = $("#displayCount").val();
        fnLoadRecords($recordCount);
    });
    function fnLoadRecords($recordCount) {

        if ($.isNumeric($recordCount) == true) {
            try {
                $iCount = parseInt($recordCount);
            }
            catch (ex) {
            }
        }
        if ($iCount >= 10) {
            $dtTable.clear();
            $.post("/DataSession/GetDecryptedListAjax", {
                "strMaxRecords": $iCount
            })
                .done(function (data) {
                    for (i = 0; i < data.length; i++) {
                        var currentRecord = data[i];
                        $dtTable.row.add(currentRecord).draw(false);
                    }
                })
                .fail(function () {
                    alert("error");
                });
            // $dtTable.row.add(["1", "2", "3", "4", "5"]).draw(false);
        }
        else {
            var options = {};
            options['closeButton'] = true;
            options['positionClass'] = "toast-top-center";
            options['type'] = "error";
            var title = "Invalid Count";
            toastr[options.type]("Count specified must be an integer greater than 10 .", title, options);

        }
    };
    $(".btnEnd").click(function (e) {
        $.post("/DataSession/CancelSession", {
        })
    });

    $(".btnExport").click(function (e) {
        console.log($dtTable.rows({ filter: 'applied' }).nodes().length);
        //filtered rows data as arrays
        var $filteredData = $dtTable.rows({ filter: 'applied' }).data();
        var $selectedIds = "";
        for (i = 0; i < $filteredData.length; i++) {
            $selectedIds = $selectedIds + $filteredData[i][0] + ",";
        }
        $('<form></form>')
            .attr('action', "/DataSession/DownloadData")
            .attr('target', '_blank')
            .attr('method', 'POST')
            .append('<input type=\'text\' name=\'id\' id=\'id\' value=\'' + b64EncodeUnicode($selectedIds) + '\'>')
            .appendTo('body').submit().remove();
    });

    document.getElementById('SessionTime').innerHTML = "Session valid for " + $timeRemaining.toString() + " more minutes.";
    var interval = setInterval(function () {
        $timeRemaining = $timeRemaining - 1;

        if ($timeRemaining > 0) {
            var Time = $timeRemaining.toString();
            document.getElementById('SessionTime').innerHTML = "Session valid for " + Time + " more minutes.";
        }
        else {
            clearInterval(interval);
            window.location = "/SessionParameters/Index";
        }
    }, 60 * 1000);

});
function b64EncodeUnicode(str) {
    // first we use encodeURIComponent to get percent-encoded UTF-8,
    // then we convert the percent encodings into raw bytes which
    // can be fed into btoa.
    return btoa(encodeURIComponent(str).replace(/%([0-9A-F]{2})/g,
        function toSolidBytes(match, p1) {
            return String.fromCharCode('0x' + p1);
        }));
}




